% Generated by roxygen2 (4.0.1): do not edit by hand
\name{quantreglp}
\alias{quantreglp}
\title{Linear Programming - Linear programming solver for quantile regression}
\usage{
quantreglp(y, X, tau = 0.5, lambda = 0)
}
\arguments{
\item{y}{An mx1 vector containing the response variables in the model}

\item{X}{An nxp matrix containing the predicting variables in the model}

\item{tau}{(optional) quantile}

\item{lambda}{(optional) regularization parameter}
}
\description{
\code{quantreglp} Function for performing quantile regression using linear programming
}
\examples{
set.seed(12345)
n <- 20
p <- 20
X <- matrix(rnorm(n*p),n,p)
b0 <- double(p)
k <- 4
b0[sample(1:p,k,replace=FALSE)] <- 10*rnorm(k)
y <- X\%*\%b0 + 0.1*rnorm(n)

lambda <- 2
tau <- 0.5
sol <- quantreglp(y,X,tau,lambda)
}
\author{
Jocelyn T. Chi
}

