% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4_architecture.R
\name{plotCDF,Curve-method}
\alias{plotCDF,Curve-method}
\title{Method for plotting the CDF of a Curve object}
\usage{
\S4method{plotCDF}{Curve}(
  theObject,
  overlay = FALSE,
  maxT = 100,
  increment = 0.1,
  xlab = "Time",
  ylab = "CDF",
  main = "CDF plot",
  type = "l",
  ...
)
}
\arguments{
\item{theObject}{The name of the RCurve Object}

\item{overlay}{Boolean whether to overlay on existing one (vs start a new one). Default=FALSE}

\item{maxT}{Maximum time to plot up to. Default=100}

\item{increment}{Plotting time increment. Default=0.1}

\item{xlab}{X-axis label. Default="Time"}

\item{ylab}{Y-axis label. Default="CDF"}

\item{main}{title of plot. Default="CDF plot"}

\item{type}{type of plot (see standard graphical parameters). Default="l" (lines).}

\item{...}{Standard graphical parameter arguments to be passed on to 'plot'/'lines', e.g. to change appearance of plot.}
}
\description{
This plots a Curve CDF
}
\examples{
plotCDF(Weibull(100,1))
plotCDF(Weibull(100,1),xlab="Test x label",maxT=60)
plotCDF(Weibull(80,0.8),overlay=TRUE,col=2,lty=2)
}
