% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcCleaning.R
\name{removeFromZ}
\alias{removeFromZ}
\title{removeFromZ}
\usage{
removeFromZ(Z, zoneN, ptN, listZonePoint, spdata, simplitol = 0.001, n = 1)
}
\arguments{
\item{Z}{zoning geometry (list of SpatialPolygons)}

\item{zoneN}{zone neighborhood Logical matrix}

\item{ptN}{indices of data pts neighbours}

\item{listZonePoint}{list of indices of data points within zones, result of call to \code{\link{calNei}}}

\item{spdata}{spatial data}

\item{simplitol}{tolerance for spatial polygons geometry simplification}

\item{n}{minimal number of points below which a zone is removed from zoning}
}
\value{
a list with components
\describe{
\item{Z}{new zoning geometry (list of SpatialPolygons)} where zones with less than n points were removed
\item{zoneN}{new zone neighborhood Logical matrix}
\item{listZonePoint}{new list of indices of data points within zones}
}
}
\description{
removeFromZ
}
\details{
description, a paragraph
}
\examples{
data(resZTest)
K=resZTest
Z=K$zonePolygone
plotZ(Z)
# remove from Z all zones with less than 10 data points
Z2=removeFromZ(Z,K$zoneN,K$krigN,K$listZonePoint,mapTest$krigData,n=10)
printZid(Z2$Z)
}
