% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcCalCrit.R
\name{calCrit2}
\alias{calCrit2}
\title{calCrit2}
\usage{
calCrit2(matDistance, zoneNModif)
}
\arguments{
\item{matDistance}{zone distance matrix resulting from a call to calDistance}

\item{zoneNModif}{matrix of zone neigbors with FALSE on the diagonal}
}
\value{
a numerical value equal to min(mean(dij^2/(dii^2+dij^2)))
}
\description{
calCrit2
}
\details{
computes a quality criterion equal to min(2*min(dij/(dii+djj)))
see also  \code{\link{calCrit1}}, \code{\link{calCrit3}}, \code{\link{calCrit4}}, \code{\link{calCrit5}}, \code{\link{calCritMinMean}} for other criteria
}
\examples{
data(mapTest)
data(resZTest)
K=resZTest
resD = calDistance(typedist=1,mapTest$krigData,K$listZonePoint,K$zoneN,
       mapTest$krigSurfVoronoi,K$meanZone,pErr=0.9)
calCrit2(resD$matDistanceCorr,K$zoneNModif)
}
