% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbox_dem.R
\name{mapbox_dem}
\alias{mapbox_dem}
\title{Gets Digital Elevation Model (DEM) data from 'mapbox'}
\usage{
mapbox_dem(lat, long, square_km, api_key)
}
\arguments{
\item{lat}{WGS84 latitude}

\item{long}{WGS84 longitude}

\item{square_km}{length of one edge the required square area, in km}

\item{api_key}{'Mapbox' API key}
}
\value{
a raster with values corresponding to terrain height in metres
}
\description{
Gets Digital Elevation Model (DEM) data from 'mapbox'
}
\examples{
\dontrun{
#NOT RUN
#mapbox_dem() requires a 'mapbox' API key

mapbox_key = "YOUR_MAPBOX_API_KEY"

lat = 54.4502651
long = -3.1767946
square_km = 20

dem <- mapbox_dem(lat, long, square_km, mapbox_key)

}
}
