% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.geotop.table.R
\name{write.geotop.table}
\alias{write.geotop.table}
\title{Writes an R object (\code{data.frame} or \code{zoo}) into a CSV file readible by GEOtop.}
\usage{
write.geotop.table(
  x,
  file,
  wpath = NULL,
  tz = "Etc/GMT-1",
  date_field = "Date12.DDMMYYYYhhmm.",
  file_end = "",
  sep = ",",
  format = "\%d/\%m/\%Y \%H:\%M",
  na = "-9999",
  ...
)
}
\arguments{
\item{x}{R object (\code{data.frame} or \code{zoo}) to be exported and written.}

\item{file}{filename}

\item{wpath}{working path to the GEOtop simlation. If \code{wpath} is not \code{NULL} , \code{filename} will be put in \code{wpath}.}

\item{tz}{time zone. Default is \code{"Etc/GMT-1"}.  See \code{\link{get.geotop.inpts.keyword.value}} fur further details.}

\item{date_field}{string used for date-time field. Deafult is \code{"Date12.DDMMYYYYhhmm."}. See \code{\link{get.geotop.inpts.keyword.value}} fur further details.}

\item{file_end}{suffix of the file name (\code{file}) (optional). Default is \code{""}.}

\item{sep}{separator character. Default is \code{","}. See \code{\link{write.table}} fur further details.}

\item{format}{date time format. Default is \code{"\%d/\%m/\%Y \%H:\%M"}. See \code{\link{get.geotop.inpts.keyword.value}} fur further details.}

\item{na}{string for unassigned values. Defaults is \code{"-9999"}.  See \code{\link{write.table}} fur further details.}

\item{...}{further arguments for \code{\link{write.table}}.}
}
\description{
Writes an R object (\code{data.frame} or \code{zoo}) into a CSV file readible by GEOtop.
}
