% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.vectorized.geotop.recovery.R
\name{read.vectorized.geotop.recovery}
\alias{read.vectorized.geotop.recovery}
\title{Reads a text file like the one generated by  \code{\link{write.vectorized.geotop.recovery}}}
\usage{
read.vectorized.geotop.recovery(file = file, comment = "!",
  matlab.syntax = TRUE, xx = "0000", formatter = "L\%04d",
  extension = ".asc", NAflag = -9999, crs = "", ...)
}
\arguments{
\item{file}{file name to write}

\item{comment}{character. Comment indicator. Default is \code{"!"}.}

\item{matlab.syntax}{logical value. Default is \code{TRUE}. If \code{TRUE} the file syntax is like the one of a *.m Matlab script file.}

\item{formatter, extension, xx}{see \code{\link{get.geotop.recovery.state}}.}

\item{NAflag}{numeric. Default is -9999, see \code{\link{writeRasterxGEOtop}}.}

\item{crs}{Character or object of class CRS. PROJ4 type description of a Coordinate Reference System (map projection) (optional). See \code{\link{brick}} or \code{\link{raster}}.}

\item{...}{further aguments inserted as attribute}
}
\value{
a \code{\link{list}} object like \code{\link{get.geotop.recovery.state}}
}
\description{
#. containing  values and matedata of a z-layer brick referred to a time instant (e.g. date). The file is formatted like an ascii format like \code{'geotop.inpts'} file.
}
\examples{
# see the examples of read.ascii.vectorized.brick
}
\seealso{
\code{\link{write.vectorized.geotop.recovery}}
}
