% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{n_eff}
\alias{n_eff}
\title{Effective sample size}
\source{
Griffith, Daniel A. (2005). Effective geographic sample size in the presence of spatial autocorrelation. Annals of the Association of American Geographers. Vol. 95(4): 740-760.
}
\usage{
n_eff(n, rho)
}
\arguments{
\item{n}{Number of observations.}

\item{rho}{Spatial autocorrelation parameter from a simultaneous autoregressive model.}
}
\value{
Returns effective sample size n*, a numeric value.
}
\description{
An approximate calculation for the effective sample size for spatially autocorrelated data. Only valid for approximately normally distributed data.
}
\details{
Implements Equation 3 from Griffith (2005).
}
\examples{

n_eff(100, 0)
n_eff(100, 0.5)
n_eff(100, 0.9)
n_eff(100, 1)

rho <- seq(0, 1, by = 0.01)
plot(rho, n_eff(100, rho),
     type = 'l',
     ylab = "Effective Sample Size")
}
\seealso{
\link[geostan]{sim_sar}, \link[geostan]{aple}
}
