% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{prep_me_data}
\alias{prep_me_data}
\title{Prepare data for spatial measurement error models}
\usage{
prep_me_data(
  se,
  bounds = c(-Inf, Inf),
  car_parts,
  prior,
  logit = rep(FALSE, times = ncol(se))
)
}
\arguments{
\item{se}{Data frame of standard errors; column names must match (exactly) the variable names used in the model formula.}

\item{bounds}{An optional numeric vector of length two providing the upper and lower bounds, respectively, of the variables. If not provided, they will be set to c(-Inf, Inf) (i.e., unbounded). Common usages include keeping percentages between zero and one hundred or proportions between zero and one.}

\item{car_parts}{A list of data required for spatial CAR models, as created by \code{\link[geostan]{prep_car_data}}; optional. If omitted, the measurement error model will be a non-spatial Student's t model.}

\item{prior}{A named list of prior distributions (see \code{\link[geostan]{priors}}). If none are provided, default priors will be assigned. The list of priors may include the following parameters:
\describe{
\item{df}{If using a non-spatial ME model, the degrees of freedom (df) for the Student's t model is assigned a gamma prior with default parameters of \code{gamma(alpha = 3, beta = 0.2)}. Provide values for each covariate in \code{se}, listing the values in the same order as the columns of \code{se}.}

\item{location}{The prior for the location parameter (mu) is a normal (Gaussian) distribution (the default being \code{normal(location = 0, scale = 100)}). To adjust the prior distributions, provide values for each covariate in \code{se}, listing the values in the same order as the columns of se.}

\item{scale}{The prior for the scale parameters is Student's t, and the default parameters are \code{student_t(df = 10, location = 0, scale = 40)}. To adjust, provide values for each covariate in \code{se}, listing the values in the same order as the columns of se.}

\item{car_rho}{The CAR model, if used, has a spatial autocorrelation parameter, \code{rho}, which is assigned a uniform prior distribution. You must specify values that are within the permissible range of values for \code{rho}; these are automatically printed to the console by the \code{\link[geostan]{prep_car_data}} function.}

}}

\item{logit}{Optional vector of logical values (\code{TRUE}, \code{FALSE}) indicating if the variable should be logit-transformed before being modeled. When \code{TRUE}, the sampling error will be modeled on the untransformed scale as usual; however, the spatial CAR prior model (or non-spatial Student's t prior model) will be assigned to the logit-transformed variate. Transformation can be crucial for modeling proportions with frequency distributions that are highly skewed.}
}
\value{
A list of data as required for (spatial) ME models. Missing arguments will be filled in with default values, including prior distributions.
}
\description{
Prepares the list of data required for geostan's (spatial) measurement error models. Given a data frame of standard errors and any optional arguments, the function returns a list with all required data for the models, filling in missing elements with default values.
}
\examples{
data(georgia)

## for a non-spatial prior model for two covariates
se <- data.frame(ICE = georgia$ICE.se,
                 college = georgia$college.se)
ME <- prep_me_data(se)

## see default priors
print(ME$prior)

## set prior for the scale parameters
ME <- prep_me_data(se,
                   prior = list(scale = student_t(df = c(10, 10),
                                                  location = c(0, 0),
                                                  scale = c(20, 20))))

## for a spatial prior model (often recommended)
A <- shape2mat(georgia, "B")
cars <- prep_car_data(A)
ME <- prep_me_data(se,
                   car_parts = cars)
}
