% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gos.R
\name{gos}
\alias{gos}
\title{Geographically optimal similarity}
\usage{
gos(formula, data = NULL, newdata = NULL, kappa = 0.25)
}
\arguments{
\item{formula}{A formula of GOS model}

\item{data}{A data.frame of observations data}

\item{newdata}{A data.frame of prediction variables data}

\item{kappa}{A numeric value of the percentage of observation locations
with high similarity to a prediction location.
kappa = 1 - tau, where tau is the probability parameter
in quantile operator. The default kappa is 0.25, meaning
that 25% of observations with high similarity to a prediction
location are used for modelling.}
}
\value{
A list of predictions and uncertainties.
}
\description{
Function for geographically optimal similarity (GOS) model
}
\examples{
data("zn")
# log-transformation
hist(zn$Zn)
zn$Zn <- log(zn$Zn)
hist(zn$Zn)
# remove outliers
require(SecDim)
k <- rmvoutlier(zn$Zn, coef = 2.5)
dt <- zn[-k,]
# split data for validation
split <- sample(1:nrow(dt), round(nrow(dt)*0.7))
train <- dt[split,]
test <- dt[-split,]
system.time({ # 0.33s
g1 <- gos(Zn ~ Slope + Water + NDVI  + SOC + pH + Road + Mine,
           data = train, newdata = test, kappa = 0.25)
})
test$pred <- g1$pred
plot(test$Zn, test$pred)
cor(test$Zn, test$pred)

}
