% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords.subset.R
\name{coords.subset}
\alias{coords.subset}
\title{Subset landmark coordinates via a factor}
\usage{
coords.subset(A, group)
}
\arguments{
\item{A}{An array of landmarks with dimensions p x k x n}

\item{group}{A grouping factor of length n, for splitting the array into sub-arrays}
}
\description{
Subset (split) landmark coordinates via a grouping factor
}
\details{
This function splits a set of landmark coordinates into subsets, as described by a factor.  The 
results is a list of separate sets of landmarks.
}
\examples{
data(pupfish) 
group <- factor(paste(pupfish$Pop, pupfish$Sex))
levels(group)
coords.subset(A = pupfish$coords, group = group)

}
\author{
Michael Collyer
}
\keyword{utilities}

