% Generated by roxygen2 (4.0.2): do not edit by hand
\name{morphol.integr}
\alias{morphol.integr}
\title{Quantify morphological integration between two modules}
\usage{
morphol.integr(A1, A2, method = c("PLS", "RV"), warpgrids = TRUE,
  iter = 999, label = NULL, verbose = FALSE)
}
\arguments{
\item{A1}{A matrix (n x [p1 x k]) or 3D array (p1 x k x n) containing GPA-aligned coordinates for the first module}

\item{A2}{A matrix (n x [p2 x k]) or 3D array (p2 x k x n) containing GPA-aligned coordinates for the second module}

\item{method}{Method to estimate morphological integration; see below for details}

\item{warpgrids}{A logical value indicating whether deformation grids for shapes along PLS1 should be displayed
(only relevant if data for A1 or A2 [or both] were input as 3D array)}

\item{iter}{Number of iterations for significance testing}

\item{label}{An optional vector indicating labels for each specimen that are to be displayed}

\item{verbose}{A logical value indicating whether the output is basic or verbose ({method="PLS"} only) (see Value below)}
}
\value{
Function returns the a list with the following components:
  \item{value}{The estimate of morphological integration: PLS.corr or RV }
  \item{pvalue}{The significance level of the observed signal}
  \item{Xscores}{PLS scores for the first block of landmarks ({method="PLS"} only when verbose=TRUE)}
  \item{Yscores}{PLS scores for the second block of landmarks ({method="PLS"} only when verbose=TRUE)}
}
\description{
Function quantifies the degree of morphological integration between two modules of Procrustes-aligned
  coordinates
}
\details{
The function quantifies the degree of morphological integration between two modules of shape data as
  defined by landmark coordinates. It is assumed that the landmarks have previously been aligned using
  Generalized Procrustes Analysis (GPA) [e.g., with \code{\link{gpagen}}]. The function may be used to assess
  the degree of morphological integration between two separate structures or between two modules defined within
  the same landmark configuration.

Two analytical approaches are currently implemented to assess the degree of morphological
  integration:
  \enumerate{
  \item {method="PLS"} (default) the function estimates the degree of morphological
  integration using two-block partial least squares, or PLS. When used with landmark data, this analysis
  is referred to as singular warps analysis (Bookstein et al. 2003). When {method="PLS"}, the scores along
  the X & Y PLS axes are also returned, as is a plot of PLS scores from Block1 versus Block2 along the first set of
  PLS axes. Thin-plate spline deformation grids along these axes are also shown (if data were input as a 3D array).
  Note: deformation grids are displayed for each block of landmarks separately.  If the two blocks of landmarks
  are derived from a single structure (i.e. a single landmark configuration), one can plot the overall deformation
  along PLS1 using the procedure provided in the example below.
  \item {method="RV"} the function estimates the degree of morphological integration using the RV coefficient
  (Klingenberg 2009). Significance testing for both approaches is found by permuting the objects in one data
  matrix relative to those in the other. A histogram of coefficients obtained via resampling is presented,
  with the observed value designated by an arrow in the plot.
  }

If evaluating an a priori hypothesis of modularity within a structure is of interest, one may use the
   average RV coefficient as implemented in the function \code{\link{compare.modular.partitions}}.
}
\examples{
data(plethodon)
Y.gpa<-gpagen(plethodon$land)    #GPA-alignment

#Morphological integration using PLS between two modules within a structure
morphol.integr(Y.gpa$coords[1:5,,],Y.gpa$coords[6:12,,],method="PLS",iter=99)

#Morphological integration using RV between two modules within a structure
morphol.integr(Y.gpa$coords[1:5,,],Y.gpa$coords[6:12,,],method="RV",iter=99)

#Deformation plot for case when both blocks are derived from the same landmark configuration
res<-morphol.integr(Y.gpa$coords[1:5,,],Y.gpa$coords[6:12,,],method="PLS",iter=99,verbose=TRUE)
  ref<-mshape(Y.gpa$coords)   #overall reference
  plotRefToTarget(ref,Y.gpa$coords[,,which.min(res$x.scores)],method="TPS") #Min along PLS1
  plotRefToTarget(ref,Y.gpa$coords[,,which.max(res$x.scores)],method="TPS") #Max along PLS1
}
\author{
Dean Adams
}
\references{
Bookstein, F. L., P. Gunz, P. Mitteroecker, H. Prossinger, K. Schaefer, and H. Seidler.
  2003. Cranial integration in Homo: singular warps analysis of the midsagittal plane in ontogeny and
  evolution. J. Hum. Evol. 44:167-187.

Klingenberg, C. P. 2009. Morphometric integration and modularity in configurations of
  landmarks: tools for evaluating a priori hypotheses. Evol. Develop. 11:405-421.
}
\keyword{analysis}

