% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Unique}
\alias{Unique}
\title{Extract Unique Rows}
\usage{
Unique(X, rows.are.sets = FALSE)
}
\arguments{
\item{X}{Numerical matrix.}

\item{rows.are.sets}{If \sQuote{\code{TRUE}}, rows are treated as sets -
i.e., to define uniqueness, the order of the rows does not matter.}
}
\value{
Matrix of the same number of columns as \code{x}, with the unique
rows in \code{x} sorted according to the columns of \code{x}. If
\code{rows.are.sets = TRUE} the rows are also sorted.
}
\description{
\sQuote{Unique} returns a vector, data frame or array like 'x' but with
duplicate elements removed.
}
\note{
\sQuote{\code{Unique}} is (under circumstances) much quicker than the
more generic base function \sQuote{\code{unique}}.
}
\examples{
# `Unique' is faster than `unique'
x = matrix(sample(1:(4*8),4*8),ncol=4)
y = x[sample(1:nrow(x),3000,TRUE), ]
gc(); system.time(unique(y))
gc(); system.time(Unique(y))

#
z = Unique(y)
x[matorder(x),]
z[matorder(z),]
}
\author{
Raoul Grasman
}
\keyword{arith}
\keyword{array}
\keyword{math}

