% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOAbstractPropertyType.R
\docType{class}
\name{ISOAbstractPropertyType}
\alias{ISOAbstractPropertyType}
\title{ISOAbstractPropertyType}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOAbstractPropertyType
}
\description{
ISOAbstractPropertyType
}
\section{Fields}{

\describe{
\item{\code{memberName}}{[\code{\link{ISOLocalName}}]}

\item{\code{definition}}{[\code{\link{character}}]}

\item{\code{cardinality}}{[\code{\link{ISOMultiplicity}}]}

\item{\code{definitionReference}}{[\code{\link{ISODefinitionReference}}]}

\item{\code{featureCatalogue}}{[\code{\link{ISOFeatureCatalogue}}]}
}}

\section{Methods inherited from \code{\link{ISOAbstractCarrierOfCharacteristics}}}{

\describe{
 \item{\code{setFeatureType(featureType)}}{
   Sets a feature type, object of class \code{\link{ISOFeatureType}}
 }
 \item{\code{addConstraint(constraint)}}{
   Adds a constraint, object of class \code{\link{ISOConstraint}} or \code{character}
 }
 \item{\code{delConstraint(constraint)}}{
   Deletes a constraint, object of class \code{\link{ISOConstraint}} or \code{character}
 }
}
}

\section{Methods}{

\describe{
 \item{\code{new(xml, defaults)}}{
   This method is used to instantiate an \code{\link{ISOAbstractPropertyType}}
 }
 \item{\code{setMemberName(memberName)}}{
   Sets the member name. Object of class \code{\link{ISOLocalName}} or \code{"character"}
 }
 \item{\code{setDefinition(definition, locales)}}{
   Sets the definition. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setCardinality(lower, upper)}}{
   Sets the cardinality boundaries lower and upper of class \code{numeric}
 }
 \item{\code{setDefinitionReference(definitionReference)}}{
   Sets the definition Reference, object of class \code{\link{ISODefinitionReference}}
 }
 \item{\code{setFeatureCatalogue(featureCatalogue)}}{
   Sets a feature catalogue, object of class \code{\link{ISOFeatureCatalogue}}
 }
}
}

\references{
ISO 19110:2005 Methodology for Feature cataloguing
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{abstract}
\keyword{property}
\keyword{type}
