% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-webgeom-obj.R
\docType{methods}
\name{webgeom}
\alias{webgeom}
\alias{webgeom,ANY-method}
\alias{webgeom,missing-method}
\title{create webgeom object}
\usage{
webgeom(.Object, ...)

\S4method{webgeom}{missing}(.Object, ...)

\S4method{webgeom}{ANY}(.Object, ...)
}
\arguments{
\item{.Object}{any object that can be coerced into \linkS4class{webgeom}}

\item{\dots}{additional arguments passed initialize method (e.g., \code{\link{url}}). See 
the named slots above for arguments for \dots}
}
\value{
the webgeom object representing a dataset and parameters
}
\description{
A class representing a web available feature geometry.
}
\details{
slots can be accessed or set with methods of the same names 
(e.g., url(webgeom()))
}
\section{Slots}{

\describe{
\item{\code{url}}{value of type \code{"character"}, the web location for the web feature service}

\item{\code{geom}}{value of type \code{"character"}, the feature for webgeom}

\item{\code{attribute}}{the attribute (e.g., "State")}

\item{\code{values}}{the values of the attribute, (e.g., "Wisconsin") or NA (all)}
}}
\examples{
wg <- webgeom(geom = "sample:CONUS_states", 
 attribute = "STATE",
 values = "New Hampshire")
#-- use available state datasets:
wg <- webgeom('state::New Hampshire')
wg <- webgeom('state::New Hampshire,Wisconsin,Alabama')
#-- use available Level III Ecoregion datasets:
wg <- webgeom('ecoregion::Colorado Plateaus,Driftless Area')
#-- use available simplified HUC8s:
wg <- webgeom('HUC8::09020306,14060009')
wg <- webgeom()

\dontrun{
## Steps to find data on Howard County in Texas:
#1) locate the \\code{geom} for counties by looking at the options for geoms
query(webgeom(), 'geoms') # discover sample:Counties
#2) locate the \\code{attribute} for county names by looking at the options for attributes
query(webgeom(geom='sample:Counties'), 'attributes') # discover COUNTY and FIPS
#3) look at the options for county names and FIPS codes
counties <- data.frame(STCountyFIPS=query(webgeom(geom='sample:Counties', 
  attribute='STATE,COUNTY,FIPS'), 'values'), stringsAsFactors=FALSE)
counties$FIPS=substring(counties$STCountyFIPS, nchar(counties$STCountyFIPS)-4)
counties$State=substr(counties$STCountyFIPS, 1, 2)
counties$County=substring(counties$STCountyFIPS, 3, nchar(counties$STCountyFIPS)-5)
howard_fips <- unique(counties[counties$State=='TX' & counties$County=='Howard County', 'FIPS'])
#4a) create a webgeom for all of the Howard Counties in the US combined 
# (this may not be the behavior you expected!)
geom <- webgeom(geom='sample:Counties', attribute='COUNTY', values="Howard County")
#4b) create a webgeom for just the Howard County in Texas
geom <- webgeom(geom='sample:Counties', attribute='FIPS', values=howard_fips)
#5) get data for all the Howard Counties combined
fabric <- webdata(url = 'http://cida.usgs.gov/thredds/dodsC/stageiv_combined', 
variables = "Total_precipitation_surface_1_Hour_Accumulation", 
times = c(as.POSIXct("2016-06-06 05:00:00"), 
          as.POSIXct("2016-06-07 05:00:00")))
job <- geoknife(geom, fabric, wait = TRUE)
precipData <- result(job)
head(precipData)
}
}
\author{
Jordan S Read
}
\seealso{
\code{\link{url}}, \code{\link{geom}}, \code{\link{attribute}}, \code{\link{values}}
}

