% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_download.R
\name{get_name_from_area_code}
\alias{get_name_from_area_code}
\alias{get_name_from_area_code.acs_5yr}
\title{Get name from area code}
\usage{
get_name_from_area_code(ac, area)

\method{get_name_from_area_code}{acs_5yr}(ac, area)
}
\arguments{
\item{ac}{An \code{acs_5yr} object.}

\item{area}{A string, area name.}
}
\value{
A vector, area code.
}
\description{
Get the name of the area from the code that appears in the name of the area
files.
}
\examples{

dir <- system.file("extdata/acs_5yr", package = "geogenr")
ac <- acs_5yr(dir)

name <- ac |>
  get_name_from_area_code(area = "METDIV")

}
\seealso{
Other information functions: 
\code{\link{get_code_from_area_name}()}
}
\concept{information functions}
