% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00Classes.r
\docType{class}
\name{GpsCoordinates-class}
\alias{GpsCoordinates-class}
\title{GPS Coordinates Class}
\description{
A class to handle gps coordinates.
}
\section{Slots}{

\describe{
\item{\code{address}}{address of the gps ascii file}

\item{\code{exact}}{data frame that contains measured gps coordinates}

\item{\code{relative}}{relative coordinates, normalized to (0,0)}

\item{\code{lm}}{linear model of the measured gps coordinates}

\item{\code{lmRelative}}{linear model of relative coordinates}
}}

\examples{
gpsCoordinates = new('GpsCoordinates', address = system.file('extdata/gps/p1.txt',
                 package='geoelectrics'))

data(sinkhole)
sinkhole@profiles[[1]]@gpsCoordinates
sinkhole@profiles[[1]]@gpsCoordinates@address
sinkhole@profiles[[1]]@gpsCoordinates@exact
sinkhole@profiles[[1]]@gpsCoordinates@lm
sinkhole@profiles[[1]]@gpsCoordinates@relative
sinkhole@profiles[[1]]@gpsCoordinates@lmRelative
}
\seealso{
\code{\link{Profile-class}}, \code{\link{ProfileSet-class}},
\code{\link{adjustHeight}}, \code{\link{calcRelativeCoords}}
}
