% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodimension_get_level_layer.R
\name{get_level_layer}
\alias{get_level_layer}
\alias{get_level_layer.geodimension}
\title{Get level layer}
\usage{
get_level_layer(
  gd,
  level_name = NULL,
  geometry = NULL,
  only_key = FALSE,
  surrogate_key = FALSE,
  inherited = FALSE,
  add_prefix = TRUE
)

\method{get_level_layer}{geodimension}(
  gd,
  level_name = NULL,
  geometry = NULL,
  only_key = FALSE,
  surrogate_key = FALSE,
  inherited = FALSE,
  add_prefix = TRUE
)
}
\arguments{
\item{gd}{A \code{geodimension} object.}

\item{level_name}{A string.}

\item{geometry}{A string.}

\item{only_key}{A boolean.}

\item{surrogate_key}{A boolean.}

\item{inherited}{A boolean.}

\item{add_prefix}{A boolean.}
}
\value{
A \code{sf} object.
}
\description{
Get a geographic layer associated with a level. We can select the geometry
and, using boolean parameters, which attributes are included in the layer's
table: only the attributes that make up the key, the subrogate key, inherited
attributes.
}
\details{
In case of inheriting attributes from other levels, in the table, these can
have as a prefix the name of the level in uppercase.
}
\examples{
library(tidyr)
library(sf)

ll <- gd_us \%>\%
  get_level_layer(level_name = "division",
                  only_key = TRUE,
                  surrogate_key = TRUE)

}
\seealso{


Other information output functions: 
\code{\link{get_higher_level_names}()},
\code{\link{get_level_data}()},
\code{\link{get_level_geometries}()},
\code{\link{get_level_names}()}
}
\concept{information output functions}
