% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_obs_dens.R
\name{vis_obs_dens}
\alias{vis_obs_dens}
\title{Visualize observed densities}
\usage{
vis_obs_dens(
  actual_data,
  dens_1,
  dens_2 = NA,
  dens_3 = NA,
  color_actual = "darkgrey",
  color_dens_1 = "#D55E00",
  color_dens_2 = "#0072B2",
  color_dens_3 = "#009E73",
  time_unit
)
}
\arguments{
\item{actual_data}{actual data in the form of `hyperframe$column`.}

\item{dens_1}{im object that represents densities}

\item{dens_2}{density 2 (if any). By default, `NA`.}

\item{dens_3}{density 3 (if any). By default, `NA`.}

\item{color_actual}{color for actual data. By default, `"darkgrey"`.}

\item{color_dens_1}{color for actual data. By default, `"#D55E00"`.}

\item{color_dens_2}{color for actual data. By default, `"#0072B2"`.}

\item{color_dens_3}{color for actual data. By default, `"#009E73"`.}

\item{time_unit}{x-axis label of the output}
}
\value{
list of dataframe and two ggplot objects for comparison of densities and residuals
}
\description{
`vis_obs_dens()` visualizes actual and predicted counts 
generated by [get_obs_dens()].
}
