% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_state.R
\name{read_state}
\alias{read_state}
\title{Download shapefiles of Brazilian states as sf objects.}
\usage{
read_state(
  code_state = "all",
  year = 2010,
  simplified = TRUE,
  showProgress = TRUE
)
}
\arguments{
\item{code_state}{The two-digit code of a state or a two-letter uppercase abbreviation (e.g. 33 or "RJ"). If code_state="all", all states will be loaded.}

\item{year}{Year of the data (defaults to 2010)}

\item{simplified}{Logic FALSE or TRUE, indicating whether the function returns the
data set with 'original' resolution or a data set with 'simplified' borders (Defaults to TRUE).
For spatial analysis and statistics users should set simplified = FALSE. Borders have been
simplified by removing vertices of borders using st_simplify{sf} preserving topology with a dTolerance of 100.}

\item{showProgress}{Logical. Defaults to (TRUE) display progress bar}
}
\description{
Data at scale 1:250,000, using Geodetic reference system "SIRGAS2000" and CRS(4674)
}
\examples{
\donttest{

library(geobr)

# Read specific state at a given year
  uf <- read_state(code_state=12, year=2017)

# Read specific state at a given year
  uf <- read_state(code_state="SC", year=2000)

# Read all states at a given year
  ufs <- read_state(code_state="all", year=2010)

}
}
\seealso{
Other general area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_census_tract}()},
\code{\link{read_conservation_units}()},
\code{\link{read_country}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_region}()},
\code{\link{read_semiarid}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_weighting_area}()}
}
\concept{general area functions}
