% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\name{spc.Read_NOMAD_v2}
\alias{spc.Read_NOMAD_v2}
\title{Read the NOMAD v2 bio-optical database}
\usage{
spc.Read_NOMAD_v2(skip.all.na.rows = TRUE)
}
\arguments{
\item{skip.all.na.rows}{\code{logical} whether or not eliminate records where all 
channels are NAs}
}
\value{
Returns an object of class \code{data.frame}.
}
\description{
Imports the NOMAD v2 database of the SeaBASS project. More information 
about this dataset can be found at \url{https://seabass.gsfc.nasa.gov/wiki/NOMAD}
}
\examples{
ap = spc.Read_NOMAD_v2()
class(ap)
spc.plot.plotly(ap[[4]], plot.max=15)

}
