% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\docType{methods}
\name{sort,Spectra-method}
\alias{sort,Spectra-method}
\title{Sort a Spectra object}
\usage{
\S4method{sort}{Spectra}(x, decreasing = FALSE, na.last = NA, which.col,
  ...)
}
\arguments{
\item{x}{A \code{Spectra} object}

\item{decreasing}{Logical. If TRUE, then the rows are sorted in decreasing order. Passed on to the
sort.idx() function from the base package. Default is FALSE.}

\item{na.last}{for controlling the treatment of NAs. Passed on to the
sort.idx() function from the base package. Default is NA.}

\item{which.col}{A character, defining the name of the column to be used in the sorting}

\item{...}{arguments to be passed to or from methods. See help of \code{\link{sort}}.}
}
\description{
Sort a \code{Spectra} object with respect to its rows with respect to values of one 
given column (specified by which.col). Sorting with respect to multiple columns is not implemented yet.
}
\examples{
sp <- spc.example_spectra()
sp2 <- sort(sp, which.col="Offset")
sp2$Offset
sp2 <- sort(sp, which.col="CAST", decreasing=TRUE)
sp2$CAST

}
