% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain.R
\name{read_uniform_term}
\alias{read_uniform_term}
\title{Attempts to parse a single term in x into power_numer and power_denom.}
\usage{
read_uniform_term(s)
}
\arguments{
\item{s}{A string, the variable side of an inequality expression. Please refer to \code{make_domain()}.}
}
\value{
\item{power_numers}{The uniform numerator in the power (e.g. \code{-2} for \code{x^(-2/3)}).}
   \item{power_denoms}{The uniform denominator in the power (e.g. \code{3} for \code{x^(-2/3)}).}
}
\description{
Attempts to parse a single term in x into power_numer and power_denom.
}
\details{
Returns \code{NULL} if \code{s} is not a single uniform term in \code{x} (e.g. \code{x^2} is uniform, while \code{x1^2+x2^2} is not uniform).
}
\examples{
p <- 30
read_uniform_term("x^2")
read_uniform_term("x^(1/3)")
read_uniform_term("exp(x)")
read_uniform_term("log(x)")
read_uniform_term("x^(-2/3)")
read_uniform_term("x")
read_uniform_term("exp(-23x)")
}
