% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_lines.R
\name{count_lines}
\alias{count_lines}
\title{Count the number of lines of a file}
\usage{
count_lines(file, ext = NA, verbose = TRUE)
}
\arguments{
\item{file}{The input file path to read (a string).}

\item{ext}{An optional extension.
If \code{NA} (default), \code{file} is expected to exist as-is.
Otherwise, if \code{file} doesn't exist and the extension was missing, then this extension is added.}

\item{verbose}{If \code{TRUE} (default), writes a message reporting the file whose lines are being counted (after adding extensions if it was needed).}
}
\value{
The number of lines in the file.
}
\description{
This function returns the number of lines in a file.
It is intended to result in fast retrieval of numbers of individuals (from FAM or equivalent files) or loci (BIM or equivalent files) when the input files are extremely large and no other information is required from these files.
This code uses C++ to quickly counts lines (like linux's \code{wc -l} but this one is cross-platform).
}
\details{
Note: this function does not work correctly with compressed files (they are not uncompressed prior to counting newlines).
}
\examples{
# count number of individuals from an existing plink *.fam file
file <- system.file("extdata", 'sample.fam', package = "genio", mustWork = TRUE)
n_ind <- count_lines(file)
n_ind

# count number of loci from an existing plink *.bim file
file <- system.file("extdata", 'sample.bim', package = "genio", mustWork = TRUE)
m_loci <- count_lines(file)
m_loci

}
