% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGE_Model.R
\name{GGEmodel}
\alias{GGEmodel}
\title{Site Regression model}
\usage{
GGEmodel(
  Data,
  genotype = "gen",
  environment = "env",
  response = "yield",
  rep = NULL,
  centering = "tester",
  scaling = "none",
  SVP = "symmetrical"
)
}
\arguments{
\item{Data}{dataframe with genotypes, environments, repetitions (if any) and
the phenotypic trait of interest. Variables can be in any order,
even additional variables that will not be used in the model may be present
in the data.}

\item{genotype}{column name for genotypes.}

\item{environment}{column name for environments.}

\item{response}{column name for the phenotypic trait.}

\item{rep}{column name for replications. If this argument is NULL, there are
no replications in the data. Defaults to NULL.}

\item{centering}{centering method. Either `"tester"` for tester centered
(G+GE), `"global"` for global centered (E+G+GE), `"double"` for double
centered (GE) or `"none"` for no centering. Defaults to `"tester"`.}

\item{scaling}{scaling method. Either `"sd"` for standard deviation or
`"none"` for no scaling. Defaults to `"none"`.}

\item{SVP}{method for singular value partitioning. Either `"row"`, `"column"`,
`"dual"` or `"symmetrical"`. Defaults to `"symmetrical"`.}
}
\value{
A list of class \code{GGE_Model} containing:
 \item{coordgenotype}{plotting coordinates for each genotype in every component.}
 \item{coordenviroment}{plotting coordinates for each environment in every
 component.}
 \item{eigenvalues}{vector of eigenvalues for each component.}
 \item{vartotal}{overall variance.}
 \item{varexpl}{percentage of variance explained by each component.}
 \item{labelgen}{genotype names.}
 \item{labelenv}{environment names.}
 \item{axes}{axis labels.}
 \item{Data}{scaled and centered input data.}
 \item{centering}{name of centering method.}
 \item{scaling}{name of scaling method.}
 \item{SVP}{name of SVP method.}
}
\description{
The Site Regression model (also called genotype +
 genotype-by-environment (GGE) model) is a powerful tool for effective
 analysis and interpretation of data from multi-environment trials in
 breeding programs. This function is a wrapper for
 \code{\link[GGEBiplots]{GGEModel}} from the
 \href{https://CRAN.R-project.org/package=GGEBiplots}{GGEBiplots package},
 with the following enhacements:
 \itemize{
   \item It can be used for data from trials with repetitions (there is no
   need to calculate means beforehand)
   \item Other variables not used in the analysis can be present in the
   dataset.
   \item Variables can be in any order in the dataset.
 }
}
\examples{

 library(geneticae)
 # Data without replication
 library(agridat)
 data(yan.winterwheat)
 GGE1 <- GGEmodel(yan.winterwheat, genotype = "gen", environment = "env",
                  response = "yield", centering = "tester")

 # Data with replication
 data(plrv)
 GGE2 <- GGEmodel(plrv, genotype = "Genotype", environment = "Locality",
                  response = "Yield", rep = "Rep", centering = "tester")

}
\references{
Sam Dumble (2017). GGEBiplots: GGE Biplots with 'ggplot2'. R
 package version 0.1.1. \url{https://CRAN.R-project.org/package=GGEBiplots}

Yan W, Kang M (2003). \emph{GGE Biplot Analysis: A Graphical Tool
 for Breeders, Geneticists, and Agronomists}. CRC Press.

Yan W, Kang M (2002). \emph{Singular-Value Partitioning in Biplot
 Analysis of Multienvironment Trial Data}. Agronomy Journal, 94, 990-996.
 \doi{10.2134/agronj2002.0990}
}
