% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kern_ctrl.R
\name{kern_ctrl}
\alias{kern_ctrl}
\title{Kernel regression with control variables and optional residuals and gradients.}
\usage{
kern_ctrl(
  dep.y,
  reg.x,
  ctrl,
  tol = 0.1,
  ftol = 0.1,
  gradients = FALSE,
  residuals = FALSE
)
}
\arguments{
\item{dep.y}{{Data on the dependent (response) variable}}

\item{reg.x}{{Data on the regressor (stimulus) variable}}

\item{ctrl}{{Data matrix on the control variable(s) kept outside the 
causal paths.
A constant vector is not allowed as a control variable.}}

\item{tol}{{Tolerance on the position of located minima of the cross-validation 
function (default=0.1)}}

\item{ftol}{{Fractional tolerance on the value of cross validation function
evaluated at local minima  (default=0.1)}}

\item{gradients}{{Set to TRUE if gradients computations are desired}}

\item{residuals}{{Set to TRUE if residuals are desired}}
}
\value{
Creates a model object `mod' containing the entire kernel regression output.
If this function is called as \code{mod=kern_ctrl(x,y,ctrl=z)}, the researcher can
simply type \code{names(mod)} to reveal the large variety of outputs produced by `npreg' 
of the `np' package.
The user can access all of them at will using the dollar notation of R.
}
\description{
Allowing matrix input of control variables, this function runs kernel regression 
with options for residuals and gradients.
}
\note{
This is a work horse for causal identification.
}
\examples{

\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:50],ncol=5)
require(np)
k1=kern_ctrl(x[,1],x[,2],ctrl=x[,4:5])
print(k1$R2) #prints the R square of the kernel regression
}

}
\references{
Vinod, H. D. `Generalized Correlation and Kernel Causality with 
 Applications in Development Economics' in Communications in 
 Statistics -Simulation and Computation, 2015, 
 \url{http://dx.doi.org/10.1080/03610918.2015.1122048}
}
\seealso{
See \code{\link{kern}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{apd  amorphous partial derivative}
\concept{kernel regression gradients}
\concept{kernel regression residuals}
