% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{Linkage}
\alias{Linkage}
\alias{test_LD}
\alias{write_LD_tables}
\title{Tables and exact test for genotypic linkage disequilibrium}
\usage{
test_LD(inputFile, outputFile = "", settingsFile = "",
  dememorization = 10000, batches = 100, iterations = 5000,
  verbose = interactive())

write_LD_tables(inputFile, outputFile = "", verbose = interactive())
}
\arguments{
\item{inputFile}{The path of the input file, in Genepop format}

\item{outputFile}{character: The path of the output file}

\item{settingsFile}{character: The path of the settings file}

\item{dememorization}{integer: length of dememorization step of Markov chain algorithm}

\item{batches}{integer: Number of batches}

\item{iterations}{integer: Iterations per batch}

\item{verbose}{logical: whether to print some information}
}
\value{
The path of the output file is returned invisibly.
}
\description{
Exact test for each pair of loci in each population. See \href{../doc/all-menu-options.html#option-2-tests-and-tables-for-linkage-disequilibrium}{this section} of the Genepop executable documentation for more information on the statistical methods.
}
\examples{
locinfile <- genepopExample('sample.txt')
test_LD(locinfile,'sample.txt.DIS')
if ( ! interactive()) clean_workdir(otherfiles='sample.txt')
locinfile <- genepopExample('sample.txt')
write_LD_tables(locinfile,'sample.txt.TAB')
if ( ! interactive()) clean_workdir(otherfiles='sample.txt')
}
