% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{Nm_private}
\alias{Nm_private}
\title{Private allele method}
\usage{
Nm_private(inputFile, outputFile = "", dataType = "Diploid",
  verbose = interactive())
}
\arguments{
\item{inputFile}{The path of the input file, in Genepop format}

\item{outputFile}{character: The path of the output file}

\item{dataType}{character: The haploid and diploid data}

\item{verbose}{logical: whether to print some information}
}
\value{
The path of the output file is returned invisibly.
}
\description{
Estimation of Nm by private allele method of Slatkin and Barton. See \href{../doc/all-menu-options.html#option-4-private-alleles}{this section} of the Genepop executable documentation for more information on the statistical methods.
}
\examples{
infile <- system.file('extdata', 'sample.txt',package='genepop')
locinfile <- 'sample.txt' ## file in user's directory not in R's extdata directory
check <- file.copy(infile,locinfile,overwrite=TRUE)
Nm_private(locinfile,'sample.txt.PRI')
if ( ! interactive()) clean_workdir(otherfiles='sample.txt')
}
