% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genGO.R
\name{genGO}
\alias{genGO}
\title{Gene GO enrichment analysis}
\usage{
genGO(
  id,
  org,
  ont,
  use_symbol = TRUE,
  pAdjustMethod = "BH",
  pvalueCutoff = 0.05,
  qvalueCutoff = 0.1,
  minGSSize = 10,
  maxGSSize = 500,
  universe,
  ...
)
}
\arguments{
\item{id}{A vector of gene id which can be entrez, ensembl or symbol.}

\item{org}{Organism name from `biocOrg_name`.}

\item{ont}{One of "bp", "mf", and "cc" subontologies, or "all" for all
three.}

\item{use_symbol}{Logical to set result gene id as gene symbol, default is TRUE.}

\item{pAdjustMethod}{One of "holm", "hochberg", "hommel", "bonferroni", "BH",
"BY", "fdr", "none".}

\item{pvalueCutoff}{Adjusted pvalue cutoff, default is 0.05.}

\item{qvalueCutoff}{Adjusted pvalue cutoff, default is 0.1.}

\item{minGSSize}{Minimal size of each gene set for analyzing, default is 10.}

\item{maxGSSize}{Maximal size of each gene set for analyzing, default is 500.}

\item{universe}{Background genes. If missing, then all gene list in
orgdb will be used as background.}

\item{...}{other argument to `enrichGO` function}
}
\value{
A `data.frame` contains gene ratio and fold enrichment.
}
\description{
Gene GO enrichment analysis
}
\examples{
\donttest{
data(geneList, package="genekitr")
id <- names(geneList)[1:100]
ego <- genGO(id, org = 'human',ont = 'cc',pvalueCutoff = 0.01,
  qvalueCutoff = 0.1 ,use_symbol = FALSE)
head(ego)
}
}
