% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqs2hap.R
\name{seqs2hap}
\alias{seqs2hap}
\alias{allignSeqs}
\alias{trimSeqs}
\title{Generate Hap Results from Seqs}
\usage{
seqs2hap(seqs,
         Ref = names(seqs)[1],
         hyb_remove = TRUE, na.drop = TRUE,
         maxGapsPerSeq = 0.25,
         hapPrefix = "H", ...)

allignSeqs(seqs, ...)

trimSeqs(seqs,
         minFlankFraction = 0.1)
}
\arguments{
\item{seqs}{object of DNAStringSet or DNAMultipleAlignment class}

\item{Ref}{the name of reference sequences.
Default as the name of the first sequence}

\item{hyb_remove}{whether remove accessions contains hybrid site or not.
Default as \code{TRUE}}

\item{na.drop}{whether drop sequeces contain "N"
Default as \code{TRUE}.}

\item{maxGapsPerSeq}{value in \verb{[0, 1]} that indicates the maximum
fraction of gaps allowed in each seq after alignment (default as 0.25).
Seqs with gap percent exceed that will be dropped}

\item{hapPrefix}{prefix of hap names. Default as "H"}

\item{...}{parameters will pass to \code{muscle::muscle()}}

\item{minFlankFraction}{A value in \verb{[0, 1]} that indicates the minimum
fraction needed to call a gap in the consensus string (default as 0.1).}
}
\value{
object of hapResult class
}
\description{
generate hapResults from aligned and trimed sequences

allign imported sequences
}
\examples{
\donttest{
data("geneHapR_test")
seqs <- allignSeqs(seqs)
seqs <- trimSeqs(seqs,
         minFlankFraction = 0.1)
hapResult <- seqs2hap(seqs,
                      Ref = names(seqs)[1],
                      hyb_remove = TRUE, na.drop = TRUE,
                      maxGapsPerSeq = 0.25,
                      hapPrefix = "H")
}
}
\seealso{
\code{\link[muscle:muscle]{muscle::muscle()}}
}
