% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gender_df.R
\name{gender_df}
\alias{gender_df}
\title{Use gender prediction with data frames}
\usage{
gender_df(data, name_col = "name", year_col = "year", method = c("ssa",
  "ipums", "napp", "demo"))
}
\arguments{
\item{data}{A data frame containing first names and birth year or range of
potential birth years.}

\item{name_col}{A string specifying the name of the column containing the
first names.}

\item{year_col}{Either a single string specifying the birth year associated
with the first name, or character vector with two elements: the names of
the columns with the minimum and maximum years for the range of potential
birth years.}

\item{method}{One of the historical methods provided by this package:
\code{"ssa"}, \code{"ipums"}, \code{"napp"}, or \code{"demo"}. See
\code{\link{gender}} for details.}
}
\value{
A data frame with columns from the output of the \code{gender}
  function, and one row for each unique combination of first names and birth
  years.
}
\description{
In a common use case for gender prediction, you have a data frame with a
column for first names and a column for birth years (or, two columns
specifying a minimum and a maximum potential birth year). This function wraps
the \code{\link{gender}} function to efficiently apply it to such a data
frame. The result is a data frame with one prediction of the gender for each
unique combination of first name and birth year. The resulting data frame can
then be merged back into your original data frame.
}
\examples{
library(dplyr)
demo_df <- data_frame(names = c("Hillary", "Hillary", "Hillary",
                                "Madison", "Madison"),
                      birth_year = c(1930, 2000, 1930, 1930, 2000),
                      min_year = birth_year - 1,
                      max_year = birth_year + 1,
                      stringsAsFactors = FALSE)

# Using the birth year for the predictions.
# Notice that the duplicate value for Hillary in 1930 is removed
gender_df(demo_df, method = "demo",
          name_col = "names", year_col = "birth_year")

# Using a range of years
gender_df(demo_df, method = "demo",
          name_col = "names", year_col = c("min_year", "max_year"))
}
\seealso{
\code{\link{gender}}
}
