% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plotDistanceVisNetwork_EC}
\alias{plotDistanceVisNetwork_EC}
\title{Plotting a Distance Network (error correction)}
\usage{
plotDistanceVisNetwork_EC(BC_dat, BC_dat_EC, minDist = 1, loga = TRUE,
  equal_node_sizes = TRUE, BC_threshold = NULL, ori_BCs = NULL,
  complete = FALSE, col_type = "rainbow", m = "hamming")
}
\arguments{
\item{BC_dat}{a BCdat object.}

\item{BC_dat_EC}{the corresponding error corrected BCdat object (EC_analysis has to be TRUE)}

\item{minDist}{an integer value representing the maximal distance value for which the graph will
contain edges.}

\item{loga}{a logical value indicating the use or non-use of logarithmic read count values.}

\item{equal_node_sizes}{a logical value. If TRUE, every node will have the sames size.}

\item{BC_threshold}{an integer value representing the number of barcodes for which the color-coding should be applied (starting with the barcodes with the most read counts).}

\item{ori_BCs}{a vector of character strings containing the barcode sequences (without the fixed positions of the barcode construct).}

\item{complete}{a logical value. If TRUE, every node will have at least one edge.}

\item{col_type}{a character sting, choosing one of the available color palettes.}

\item{m}{a character string, Method for distance calculation, default value is Hamming distance. Possible values
are "osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex" (see stringdist function
of the stringdist-package for more information).}
}
\value{
a visNetwork object.
}
\description{
plotDistanceVisNetwork will create a graph-like visualisation (ripple plot) of the corresponding barcode sequences
and their similarity based on the ggplot2 and the ggnetwork packages. The nodes represent the barcode sequences and their
respective size reflects the corresponding read counts. Edges between nodes indicate a distance between two barcodes
of maximal \code{minDist}.
If \code{ori_BCs} is provided the effects of the error correction function will be color-coded only for those sequences.
}
