/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import java.util.ArrayList;
import java.util.List;
import org.drugis.common.stat.DichotomousDescriptives;
import org.drugis.mtc.model.Measurement;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.NetworkModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorGenerator {
    double d_range;

    public PriorGenerator(Network network) {
        this.d_range = this.calculate(network);
    }

    public double getRandomEffectsSigma() {
        return this.d_range;
    }

    public double getInconsistencySigma() {
        return this.d_range;
    }

    public double getVagueNormalSigma() {
        return 15.0 * this.d_range;
    }

    private double calculate(Network network) {
        List<Double> means = null;
        switch (network.getType()) {
            case CONTINUOUS: {
                means = this.means(network, new ContDiff());
                break;
            }
            case RATE: {
                means = this.means(network, new DichDiff());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled network type " + (Object)((Object)network.getType()));
            }
        }
        return this.range(means);
    }

    private double range(List<Double> means) {
        double max = means.get(0);
        int i = 1;
        while (i < means.size()) {
            if (means.get(i) > max) {
                max = means.get(i);
            }
            ++i;
        }
        return max;
    }

    private List<Double> means(Network network, Diff diff) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (Study s : network.getStudies()) {
            List<Treatment> treatments = NetworkModel.getTreatments(s);
            int i = 0;
            while (i < treatments.size() - 1) {
                int j = i + 1;
                while (j < treatments.size()) {
                    Measurement m1 = NetworkModel.findMeasurement(s, treatments.get(i));
                    Measurement m2 = NetworkModel.findMeasurement(s, treatments.get(j));
                    list.add(Math.abs(diff.calc(m1, m2)));
                    ++j;
                }
                ++i;
            }
        }
        return list;
    }

    public static class ContDiff
    implements Diff {
        public double calc(Measurement m1, Measurement m2) {
            return m1.getMean() - m2.getMean();
        }
    }

    public static class DichDiff
    implements Diff {
        DichotomousDescriptives d_desc = new DichotomousDescriptives(true);

        public double calc(Measurement m1, Measurement m2) {
            return this.d_desc.logOddsRatio(m1.getResponders(), m1.getSampleSize(), m2.getResponders(), m2.getSampleSize());
        }
    }

    private static interface Diff {
        public double calc(Measurement var1, Measurement var2);
    }
}

