/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.beans;

import com.jgoodies.binding.list.ObservableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.drugis.common.beans.AbstractObservableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AffixedObservableList<E>
extends AbstractObservableList<E> {
    private final ObservableList<E> d_nested;
    private final List<E> d_prefix;
    private final List<E> d_suffix;

    public static <E> AffixedObservableList<E> createSuffixed(ObservableList<E> list, E ... suffix) {
        return new AffixedObservableList<E>(list, Collections.emptyList(), Arrays.asList(suffix));
    }

    public static <E> AffixedObservableList<E> createPrefixed(ObservableList<E> list, E ... prefix) {
        return new AffixedObservableList<E>(list, Arrays.asList(prefix), Collections.emptyList());
    }

    private AffixedObservableList(ObservableList<E> list, List<E> prefix, List<E> suffix) {
        this.d_nested = list;
        this.d_prefix = prefix;
        this.d_suffix = suffix;
        this.d_nested.addListDataListener(new ListDataListener(){

            public void intervalRemoved(ListDataEvent e) {
                AffixedObservableList.this.d_manager.fireIntervalRemoved(AffixedObservableList.this.d_prefix.size() + e.getIndex0(), AffixedObservableList.this.d_prefix.size() + e.getIndex1());
            }

            public void intervalAdded(ListDataEvent e) {
                AffixedObservableList.this.d_manager.fireIntervalAdded(AffixedObservableList.this.d_prefix.size() + e.getIndex0(), AffixedObservableList.this.d_prefix.size() + e.getIndex1());
            }

            public void contentsChanged(ListDataEvent e) {
                AffixedObservableList.this.d_manager.fireContentsChanged(AffixedObservableList.this.d_prefix.size() + e.getIndex0(), AffixedObservableList.this.d_prefix.size() + e.getIndex1());
            }
        });
    }

    @Override
    public E get(int index) {
        if (index < this.d_prefix.size()) {
            return this.d_prefix.get(index);
        }
        if ((index -= this.d_prefix.size()) < this.d_nested.size()) {
            return this.d_nested.get(index);
        }
        return this.d_suffix.get(index -= this.d_nested.size());
    }

    @Override
    public int size() {
        return this.d_prefix.size() + this.d_nested.size() + this.d_suffix.size();
    }
}

