/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import java.util.Map;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.Parameter;

public class Derivation {
    private final Map<? extends Parameter, Integer> d_pmtz;

    public Derivation(Map<? extends Parameter, Integer> pmtz) {
        assert (!pmtz.isEmpty());
        this.d_pmtz = pmtz;
    }

    public double[] calculate(MCMCResults results, int c) {
        double[] result = new double[results.getNumberOfSamples()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.calculate(results, c, i);
        }
        return result;
    }

    public double calculate(MCMCResults results, int c, int i) {
        double val = 0.0;
        for (Map.Entry<? extends Parameter, Integer> e : this.d_pmtz.entrySet()) {
            val += (double)e.getValue().intValue() * results.getSample(results.findParameter(e.getKey()), c, i);
        }
        return val;
    }
}

