/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;

public class Part {
    private Set<Treatment> d_treatments = new HashSet<Treatment>();
    private Set<Study> d_studies;

    public Part(final Treatment t1, final Treatment t2, Set<Study> studies) {
        if (studies.isEmpty()) {
            throw new IllegalArgumentException("The given list of studies may not be empty.");
        }
        if (CollectionUtils.exists(studies, new Predicate<Study>(){

            @Override
            public boolean evaluate(Study s) {
                return !s.containsTreatment(t1) || !s.containsTreatment(t2);
            }
        })) {
            throw new IllegalArgumentException("All studies must contain both treatments");
        }
        this.d_treatments.add(t1);
        this.d_treatments.add(t2);
        this.d_studies = studies;
    }

    public Part(Treatment ta, Treatment tb, Collection<Study> studies) {
        this(ta, tb, (Set<Study>)new HashSet<Study>(studies));
    }

    public Set<Treatment> getTreatments() {
        return Collections.unmodifiableSet(this.d_treatments);
    }

    public Set<Study> getStudies() {
        return Collections.unmodifiableSet(this.d_studies);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Part) {
            Part other = (Part)obj;
            return ((Object)this.d_treatments).equals(other.d_treatments) && ((Object)this.d_studies).equals(other.d_studies);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.d_treatments).hashCode() * 31 + ((Object)this.d_studies).hashCode();
    }

    public String toString() {
        return "Part(" + this.d_treatments.toString() + ", " + this.d_studies.toString() + ")";
    }
}

