% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grab_funs.R
\name{grab_design_matrix}
\alias{grab_design_matrix}
\title{Grab a matrix of fixed effects from a model object}
\usage{
grab_design_matrix(data, rhs_formula)
}
\arguments{
\item{data}{the data from which to extract the matrix}

\item{rhs_formula}{the right hand side of a model formula}
}
\description{
Grab a matrix of fixed effects from a model object
}
\examples{
# Create a "desigm" matrix for the first ten rows of iris data
fit <- lm(Sepal.Width ~ Petal.Width, data = iris)
grab_design_matrix(
  data = iris[1:10, ],
  grab_fixed_formula(fit))
}
