% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_history_range.R
\name{coin_history_range}
\alias{coin_history_range}
\title{Get historical market data}
\usage{
coin_history_range(coin_id, vs_currency = "usd", from, to, max_attempts = 3)
}
\arguments{
\item{coin_id}{(character): ID of the coin of interest or a vector with \emph{several} IDs.
The maximum number of coins that can be queried simultaneously is 30.
An up-to-date list of supported coins and their IDs can be retrieved
with the \code{supported_coins()} function.}

\item{vs_currency}{(character): name of the reference currency to
express the price in. An up-to-date list of supported reference currencies (both
fiat and cryptocurrencies) can be obtained with the \code{\link[=supported_currencies]{supported_currencies()}}
function. If an unsupported \code{vs_currency} is requested, the call will
fail with the respective error message.}

\item{from}{(POSIXct): timestamp of the beginning of the period of interest
(\verb{YYYY-MM-DD HH:MM:SS}).}

\item{to}{(POSIXct): timestamp of the end of the period of interest
(\verb{YYYY-MM-DD HH:MM:SS}).}

\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{timestamp} (POSIXct);
\item \code{coin_id} (character): same as the argument \code{coin_id};
\item \code{vs_currency} (character): same as the argument \code{vs_currency};
\item \code{price} (double): coin price as of \code{timestamp};
\item \code{total_volume} (double): a 24 hours rolling-window trading volume, as
of \code{timestampt};
\item \code{market_cap} (double): market capitalisation, as of \code{timestamp}.
}
}
\description{
Retrieves coin-specific market data for a range of historical dates
}
\details{
This function returns hourly data for periods of up to 90 days
and daily data for periods that are longer than 90 days.

Sometimes, the retrieved data will contain missing values. In such
cases, the function will issue a warning and show a list
of columns that have missing values.

This function is based on the public
\href{https://www.coingecko.com/api/documentations/v3}{CoinGecko API},
which has a limit of 50 calls per minute. Please
keep this limit in mind when developing your applications.
}
\examples{
\donttest{
r <- coin_history_range(
  coin_id = "cardano",
  vs_currency = "usd",
  from = as.POSIXct("2021-01-01 13:00:00", tz = "UTC"),
  to = as.POSIXct("2021-01-01 18:00:00", tz = "UTC")
)
print(r)
}
}
