\name{samePDF}
\alias{samePDF}
\title{
  Compare Two PDF Files
}
\description{
  Check whether two PDF files have the same content, ignoring some details like
  creation time and modification time.
}
\usage{
samePDF(file1, file2)
}
\arguments{
  \item{file1, file2}{ Names of PDF files to compare. }
}
\details{
  This function will compare any two files, byte by byte, but
  if a file is a PDF file that was generated by R, it will
  discard the file header, which may contain differences that do not
  matter, such as the creation date.
}
\value{
  A logical value.
}
\author{
  Paul Murrell
}
\examples{
f1 <- tempfile(fileext=".pdf")
f2 <- tempfile(fileext=".pdf")
pdf(f1)
plot(1)
dev.off()
pdf(f2)
plot(2)
dev.off()
samePDF(f1, f1)
samePDF(f1, f2)
}
\keyword{ dplot }
\concept{ visual testing }
