% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_stat}
\alias{vsi_stat}
\title{Get filesystem object info}
\usage{
vsi_stat(filename, info = "exists")
}
\arguments{
\item{filename}{Character string. The path of the filesystem object to be
queried.}

\item{info}{Character string. The type of information to fetch, one of
\code{"exists"} (the default), \code{"type"} or \code{"size"}.}
}
\value{
If \code{info = "exists"}, returns logical \code{TRUE} if the file system
object exists, otherwise \code{FALSE}. If \code{info = "type"}, returns a character
string with one of \code{"file"} (regular file), \code{"dir"} (directory),
\code{"symlink"} (symbolic link), or empty string (\code{""}). If \code{info = "size"},
returns the file size in bytes (as \code{bit64::integer64} type), or \code{-1} if an
error occurs.
}
\description{
\code{vsi_stat()} fetches status information about a filesystem object (file,
directory, etc).
This function goes through the GDAL \code{VSIFileHandler} virtualization and may
work on unusual filesystems such as in memory.
It is a wrapper for \code{VSIStatExL()} in the GDAL Common Portability Library.
Analog of the POSIX \code{stat()} function.
}
\note{
For portability, \code{vsi_stat()} supports a subset of \code{stat()}-type
information for filesystem objects. This function is primarily intended
for use with GDAL virtual file systems (e.g., URLs, cloud storage systems,
ZIP/GZip/7z/RAR archives, in-memory files).
The base R function \code{utils::file_test()} could be used instead for file
tests on regular local filesystems.
}
\examples{
data_dir <- system.file("extdata", package="gdalraster")
vsi_stat(data_dir)
vsi_stat(data_dir, "type")
# stat() on a directory doesn't return the sum of the file sizes in it,
# but rather how much space is used by the directory entry
vsi_stat(data_dir, "size")

elev_file <- file.path(data_dir, "storml_elev.tif")
vsi_stat(elev_file)
vsi_stat(elev_file, "type")
vsi_stat(elev_file, "size")

nonexistent <- file.path(data_dir, "nonexistent.tif")
vsi_stat(nonexistent)
vsi_stat(nonexistent, "type")
vsi_stat(nonexistent, "size")

# /vsicurl/ file system handler
base_url <- "https://raw.githubusercontent.com/usdaforestservice/"
f <- "gdalraster/main/sample-data/landsat_c2ard_sr_mt_hood_jul2022_utm.tif"
url_file <- paste0("/vsicurl/", base_url, f)

vsi_stat(url_file)
vsi_stat(url_file, "type")
vsi_stat(url_file, "size")
}
\seealso{
GDAL Virtual File Systems:\cr
\url{https://gdal.org/en/stable/user/virtual_file_systems.html}
}
