% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_time.R
\name{fill_time}
\alias{fill_time}
\title{Fill NA data cube pixels by simple time series interpolation}
\usage{
fill_time(cube, method = "near")
}
\arguments{
\item{cube}{source data cube}

\item{method}{interpolation method, can be "near" (nearest neighbor), "linear" (linear interpolation), "locf" (last observation carried forward), or "nocb" (next observation carried backward)}
}
\value{
a proxy data cube object
}
\description{
Create a proxy data cube, which fills NA pixels of a data cube by nearest neighbor or linear time series interpolation.
}
\details{
Please notice that completely empty (NA) time series will not be filled, i.e. the result cube might still contain NA values.
}
\note{
This function returns a proxy object, i.e., it will not start any computations besides deriving the shape of the result.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db"), quiet = TRUE) 
}
L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-01", t1="2018-12"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P3M", aggregation = "median")
L8.cube = raster_cube(L8.col, v, mask=image_mask("BQA", bits=4, values=16))
L8.rgb = select_bands(L8.cube, c("B02", "B03", "B04"))
L8.filled = fill_time(L8.rgb, "linear")
L8.filled

\donttest{
plot(L8.filled, rgb=3:1, zlim=c(5000,12000))
}

}
