% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{separate_tidy}
\alias{separate_tidy}
\title{Separate a column into multiple columns}
\usage{
separate_tidy(data, col, into = NULL, sep = "_", ...)
}
\arguments{
\item{data}{A data frame}

\item{col}{Column name or position}

\item{into}{A character vector of the new column names. Use \code{NA} to
omit the variable in the output.

If NULL, \code{separate_gc} will attempt to infer the new
column names from the column name of \code{col}}

\item{sep}{Separator between columns passed to \code{tidyr::separate}:

           If character, \code{sep} is interpreted as a regular expression.
           
           If numeric, \code{sep} is interpreted as character positions
           to split at. Positive values start at 1 at the far-left of the
           string; negative values start at -1 at the far-right of the
           string. The length of \code{sep} should be one less than 
           \code{into}}

\item{...}{Other arguments passed to \code{tidyr::separate}}
}
\value{
A data frame containing new columns in the place of \code{col}
}
\description{
This function is primarily a wrapper for \code{tidyr::separate}, which
turns a single character column into multiple columns
}
