% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_static_feeds.R
\name{get_system_pricing_plans}
\alias{get_system_pricing_plans}
\title{Save the system_pricing_plans feed.}
\usage{
get_system_pricing_plans(city, directory,
  file = "system_pricing_plans.rds")
}
\arguments{
\item{city}{A character string or a url to an active gbfs.json feed. See \code{get_gbfs_cities}
for a current list of available cities.}

\item{directory}{The name of an existing folder or folder to be created, where the feed will
will be saved.}

\item{file}{The name of the file to be saved. Must end in .rds.}
}
\value{
A .rds object generated from the current system_pricing_plans feed.
}
\description{
\code{get_system_pricing_plans} saves the system_pricing_plans feed for a given city as a .rds object. Go to 
`https://github.com/NABSA/gbfs/blob/master/gbfs.md` to see metadata for this dataset.
}
\examples{
\donttest{get_system_pricing_plans(city = 
"http://biketownpdx.socialbicycles.com/opendata/system_pricing_plans.json", directory = tempdir())}
\donttest{get_system_pricing_plans(city = "Houston", directory = tempdir())}
}
