% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_static_feeds.R
\name{get_system_hours}
\alias{get_system_hours}
\title{Save the system_hours feed.}
\usage{
get_system_hours(city, directory, file = "system_hours.rds")
}
\arguments{
\item{city}{A character string or a url to an active gbfs.json feed. See \code{get_gbfs_cities}
for a current list of available cities.}

\item{directory}{The name of an existing folder or folder to be created, where the feed will
will be saved.}

\item{file}{The name of the file to be saved. Must end in .rds.}
}
\value{
A .rds object generated from the current system_hours feed.
}
\description{
\code{get_system_hours} saves the system_hours feed for a given city as a .rds object. Go to 
`https://github.com/NABSA/gbfs/blob/master/gbfs.md` to see metadata for this dataset.
}
\examples{
\donttest{get_system_hours(city = 
"http://biketownpdx.socialbicycles.com/opendata/system_hours.json", directory = tempdir())}
\donttest{get_system_hours(city = "Phoenix", directory = tempdir())}
}
