% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_static_feeds.R
\name{get_system_information}
\alias{get_system_information}
\title{Save the system_information feed.}
\usage{
get_system_information(city, directory, file = "system_information.rds")
}
\arguments{
\item{city}{A character string or a url to an active gbfs.json feed.}

\item{directory}{The name of an existing folder or folder to be created, where the feed will
will be saved.}

\item{file}{The name of the file to be saved. Must end in .rds.}
}
\value{
A .rds object generated from the current system_information feed.
}
\description{
\code{get_system_information} saves the system_information feed for a given city as a .rds object. Go to 
`https://github.com/NABSA/gbfs/blob/master/gbfs.md` to see metadata for this dataset.
}
\examples{
\donttest{get_system_information(city = 
"http://biketownpdx.socialbicycles.com/opendata/system_information.json", directory = tempdir())}
\donttest{get_system_information(city = "Omaha",  directory = tempdir())}
}
