% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_locality_clean.R
\name{basic_locality_clean}
\alias{basic_locality_clean}
\title{Locality Cleaning - Remove missing and improbable coordinates}
\usage{
basic_locality_clean(
  df,
  latitude = "latitude",
  longitude = "longitude",
  remove.zero = TRUE,
  precision = TRUE,
  digits = 2,
  remove.skewed = TRUE,
  info.withheld = "informationWithheld"
)
}
\arguments{
\item{df}{Data frame of occurrence records returned from \code{gators_download()}.}

\item{latitude}{Default = "latitude". The name of the latitude column in the data frame.}

\item{longitude}{Default = "longitude". The name of the longitude column in the data frame.}

\item{remove.zero}{Default = TRUE. Indicates that points at (0.00, 0.00) should be removed.}

\item{precision}{Default = TRUE. Indicates that coordinates should be rounded to match the coordinate uncertainty.}

\item{digits}{Default = 2. Indicates digits to round coordinates to when \code{precision = TRUE}.}

\item{remove.skewed}{Default = TRUE. Utilizes the \code{remove_skewed()} function to remove skewed coordinate values.}

\item{info.withheld}{Default = "informationWithheld". The name of the information withheld column in the data frame.}
}
\value{
Return data frame with specimen removed that had missing or improper coordinate values.
}
\description{
The \code{basic_locality_clean()} function cleans locality by removing missing or impossible coordinates and correcting precision.
This function requires columns named 'latitude' and 'longitude'. These columns should be of type 'numeric'.
}
\details{
This function requires no additional packages.
}
\examples{
cleaned_data <- basic_locality_clean(data)

}
