% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfill.R
\name{Score}
\alias{Score}
\title{Score Columns of a Matrix Containing NAs by its Values}
\usage{
Score(mat)
}
\arguments{
\item{mat}{Numeric matrix. May contain \code{NA} values.}
}
\value{
Numeric vector of length \code{ncol(mat)}.
}
\description{
Helper function for \code{\link{Predict}} used to
score the columns of a matrix according to their values.  
The scoring of a given column is done by pair-wise comparisons with all other columns.
The comparison of columns is done by pair-wise comparisons of the non-missing values.
This procedure is robust to missing values, if all columns of the matrix
have a similar (potentially shifted) distribution of values.
}
\note{
Interfaces a C++ function. The R package Rcpp is used.
}
\examples{
mat <- rbind(c( 1,  2, NA),
             c(NA, NA,  1),
             c( 2, NA,  3),
             c( 1,  5, NA),
             c(NA,  2,  5))
s <- Score(mat)

## manual calculation in R
Mean <- function(x) mean(x, na.rm = TRUE)
sByHand <- c(Mean(c(Mean(mat[,1] > mat[,2]),
                    Mean(mat[,1] > mat[,3]))),
             Mean(c(Mean(mat[,2] > mat[,1]),
                    Mean(mat[,2] > mat[,3]))),
             Mean(c(Mean(mat[,3] > mat[,1]),
                    Mean(mat[,3] > mat[,2]))))
stopifnot(identical(s, sByHand))

}
\author{
Florian Gerber, \email{florian.gerber@math.uzh.ch}.
}
\references{
F. Gerber, R. Furrer, G. Schaepman-Strub, R. de Jong, M. E. Schaepman, 2016,
Predicting missing values in spatio-temporal satellite data.
\url{http://arxiv.org/abs/1605.01038}.
}

