      SUBROUTINE TXCARD( STRING, LFNTER, ISTAT )
C---
C--- SAVES A TRANSFORMATION FUNCTION
C---
C--- SYNTAX:   TX Xdest = FUNCTION OF Xvar1, Xvar2, ... Xvarn
C---     WHERE dest,var1,var2,...,varn REFER TO ORDINALS OF VARIABLES.
C---     EXAMPLES:
C---           TX X2 = X3 + X4
C---           TX X5=(X5-12.34) / 56.7
C---           TX IF (X3*2 < X5) REJECT
C---
C--- ARGUMENTS:
C---     STRING -- TX CARD (CHARACTER FORMAT)
C---     LFNTER -- LOGICAL UNIT FOR LIST OUTPUT
C---     ISTAT  -- RETURNED AS -1 IF ERROR, 0 OTHERWISE
C---
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      CHARACTER         STRING*(*)

#include "field.inc"

C SAVES CURRENT TRANSFORMATION

      MODE = 2
      ISAVE = 999

      CALL EVAL(MODE,STRING,LFNTER,ISAVE,
     @   MAXFLD,FLDOBS,FLDBLK,FLDTYP,FLDNAM,FLDNCH,
     @   IVAR,ANS,ISTAT)
      IF (ISTAT .NE. 0) GO TO 800
      IF (IVAR .EQ. 0) GO TO 810

      GO TO 900

C UNSUCCESSFUL RETURN

800   ISTAT = -1
      GO TO 999

810   WRITE (LFNTER,*) '** INVALID DESTINATION VARIABLE IN TX CARD **'
      WRITE (LFNTER,*) 'EXAMPLE:     X5 = (X5+X3) / 2'
      GO TO 800

C SUCCESSFUL RETURN

900   ISTAT = 0
999   RETURN
      END

      SUBROUTINE TXFORM(LRNTER,ISTAT)
C---
C--- APPLY SAVED TRANSFORMATION FUNCTIONS TO CURRENT RECORD
C---
C--- ARGUMENTS:
C---     LRNTER   -- LFN FOR LIST OUTPUT
C---     ISTAT    -- SET TO -1 IF RECORD IS TO BE REJECTED, 0 OTHERWISE
C---
C--- THE STATUS RETURNED FROM EVAL IS AS FOLLOWS:
C---  -1=ERROR, 0=OK, 1=FALSE, 2=BLANK, 3=REJECT, 4=EOX
C---
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

#include "field.inc"

C LOOP THROUGH ALL SAVED FUNCTIONS

      ISAVE = 0
100   ISAVE = ISAVE + 1

      MODE = 3
      CALL EVAL(MODE,' ',LRNTER,ISAVE,
     @   MAXFLD,FLDOBS,FLDBLK,FLDTYP,FLDNAM,FLDNCH,
     @   IVAR,ANS,ISTAT)

      IF (ISTAT .EQ. 4) GO TO 900
      IF (ISTAT .EQ. 3) GO TO 800
      IF (ISTAT .GE. 0) GO TO 100

C UNSUCCESSFUL EVALUATION

      WRITE (LRNTER,*) 'EVALUATION TIME ERROR IN TX FUNCTION #', ISAVE
      call intpr('TXFORM: ERROR',-1,0,0)
      STOP

C REJECTION

800   ISTAT = -1
CD     WRITE (*,*) 'DEBUG: <RECORD REJECTED>'
      GO TO 999

C SUCCESSFUL RETURN

900   ISTAT = 0
999   RETURN
      END
