% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdPlot2dProjection.R
\name{gdPlot2dProjection}
\alias{gdPlot2dProjection}
\title{Create an image file for generative data and data source}
\usage{
gdPlot2dProjection(
  outImageFileName,
  columnIndices,
  numberOfRandomGdPoints,
  numberOfRandomDsPoints
)
}
\arguments{
\item{outImageFileName}{Name of image file}

\item{columnIndices}{Vector of two column indices that are used for the two-dimensional projection. The indices refer to indices of active columns of data source.}

\item{numberOfRandomGdPoints}{Number of randomly selected rows in generative data}

\item{numberOfRandomDsPoints}{Number of randomly selected rows in data source}
}
\value{
None
}
\description{
Create an image file containing a two-dimensional projection for randomly selected rows in generative data and
data source. Data points of data source are drawn above data points of generative data.
}
\examples{
\donttest{gdRead("gd.bin", "iris4d.bin")
gdPlot2dProjection("gd34d.png", c(3, 4), 55000, 2500)
gdPlot2dProjection("gd12d.png", c(1, 2), 55000, 2500)}
}
