% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.galamm.R
\name{logLik.galamm}
\alias{logLik.galamm}
\title{Extract Log-Likelihood of galamm Object}
\usage{
\method{logLik}{galamm}(object, ...)
}
\arguments{
\item{object}{Object}

\item{...}{Other arguments}
}
\value{
Object of class \code{logLik}
}
\description{
Extract Log-Likelihood of galamm Object
}
\examples{
# Linear mixed model with heteroscedastic residuals
mod <- galamm(
  formula = y ~ x + (1 | id),
  weights = ~ (1 | item),
  data = hsced
)

# Extract log likelihood
logLik(mod)

}
\seealso{
\code{\link[=deviance.galamm]{deviance.galamm()}} for a function returning deviance and
\code{\link[=logLik]{logLik()}} for the generic function.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{llikAIC}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
